/*
 * Decompiled with CFR 0.152.
 */
package com.yh.dl.musicDownload.service;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.CredentialsProviderFactory;
import com.aliyun.oss.common.auth.EnvironmentVariableCredentialsProvider;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yh.dl.musicDownload.mapper.MusicDownloadMapper;
import com.yh.dl.musicDownload.model.MusicDownload;
import com.yh.dl.musicDownload.model.SearchDTO;
import com.yh.dl.musicDownload.service.QobuzSearchService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jsoup.Jsoup;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MusicDownloadService {
    @Autowired
    private MusicDownloadMapper musicDownloadMapper;
    private int retryCount = 0;

    public void processBuilder(MusicDownload musicDownload, Integer serviceNumber) {
        musicDownload.setState("\u8f6c\u5b58\u4e2d");
        musicDownload.setServiceId(serviceNumber);
        if (musicDownload.getStartTime() == null) {
            musicDownload.setStartTime(new Date());
        }
        this.musicDownloadMapper.updateById((Object)musicDownload);
        String url = musicDownload.getUrl();
        String[] ss = url.split("/");
        String qID = ss[ss.length - 1];
        boolean retry = false;
        boolean error = false;
        boolean downloadedCount = false;
        String command = "qobuz-dl dl --no-db https://play.qobuz.com/album/" + qID;
        ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
        processBuilder.redirectErrorStream(true);
        Process process = null;
        try {
            String line;
            process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String name = null;
            System.out.println("\u8f6c\u5b58\u4efb\u52a1\u6267\u884c\u5f00\u59cb");
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                if (line.contains("AttributeError")) {
                    retry = true;
                }
                if (line.contains("Error getting release") || line.contains("This release is not streamable")) {
                    if (name != null) {
                        this.rf(name);
                    }
                    musicDownload.setState("\u4e2d\u8f6c\u5931\u8d25\u79ef\u5206\u5df2\u8fd4\u8fd8\uff0c\u8bf7\u6362\u533a\u5c1d\u8bd5");
                    this.musicDownloadAddOne(musicDownload.getUserId(), musicDownload.getPoints());
                    this.musicDownloadMapper.updateById((Object)musicDownload);
                    error = true;
                    break;
                }
                if (name == null) {
                    name = MusicDownloadService.getName((String)line);
                    System.out.println("name" + name);
                }
                if (!line.contains("0.00/")) continue;
                this.updateSchedule(musicDownload, this.getNum(name));
            }
            System.out.println("\u8f6c\u5b58\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            if (!error) {
                if (retry) {
                    if (this.retryCount < 1) {
                        this.processBuilder(musicDownload, serviceNumber);
                        ++this.retryCount;
                    }
                } else {
                    this.jy(musicDownload);
                    assert (name != null);
                    musicDownload.setState("\u538b\u7f29\u6253\u5305\u4e2d");
                    this.musicDownloadMapper.updateById((Object)musicDownload);
                    String file = this.zip(name);
                    assert (name != null);
                    this.rf(name);
                    String downloadUrl = file;
                    musicDownload.setState("\u8f6c\u5b58\u5b8c\u6210");
                    musicDownload.setDownloadUrl(downloadUrl);
                    name = name.replace("#", "");
                    musicDownload.setFileName(name + ".zip");
                    musicDownload.setSchedule(Integer.valueOf(100));
                    TimeZone timeZone = TimeZone.getTimeZone("Asia/Shanghai");
                    Calendar calendar = Calendar.getInstance(timeZone);
                    Date today = calendar.getTime();
                    calendar.setTime(today);
                    calendar.add(5, 3);
                    Date sevenDaysLater = calendar.getTime();
                    musicDownload.setExpirationTime(sevenDaysLater);
                    this.musicDownloadMapper.updateById((Object)musicDownload);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u4e0b\u8f7d\u547d\u4ee4\u6267\u884c\u5931\u8d25\u3002");
        }
    }

    public void jy(MusicDownload musicDownload) {
        musicDownload.setState("\u6821\u9a8c\u4e2d");
        this.musicDownloadMapper.updateById((Object)musicDownload);
        String url = musicDownload.getUrl();
        String[] ss = url.split("/");
        String qID = ss[ss.length - 1];
        String command = "qobuz-dl dl --no-db https://play.qobuz.com/album/" + qID;
        ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
        processBuilder.redirectErrorStream(true);
        Process process = null;
        try {
            String line;
            process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getNum(String name) {
        String sourceFolder = "/www/wwwroot/m3/Qobuz Downloads/" + name;
        Path rootDirectory = Paths.get(sourceFolder, new String[0]);
        AtomicInteger fileCount = new AtomicInteger(0);
        try {
            Files.walkFileTree(rootDirectory, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int getCount = fileCount.get();
        if (getCount > 0) {
            --getCount;
        }
        return getCount;
    }

    private String zip(String name) {
        String sourceFolder = "/www/wwwroot/m3/Qobuz Downloads/" + name;
        long timestampMillis = System.currentTimeMillis();
        String file = "";
        name = name.replace("#", "");
        file = "m3/" + name + ".zip";
        String destinationFile = "/www/wwwroot/" + file;
        File folderToBeZipped = new File(sourceFolder);
        if (folderToBeZipped.exists()) {
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destinationFile));){
                MusicDownloadService.addFolderToZip((ZipOutputStream)zos, (File)folderToBeZipped, null);
                System.out.println("\u6210\u529f\u521b\u5efa\u5e76\u4fdd\u5b58\u4e86\u538b\u7f29\u6587\u4ef6\uff01");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("\u6307\u5b9a\u7684\u6e90\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff01");
        }
        return file;
    }

    public int deleteDataGQ(MusicDownload musicDownload) {
        if (musicDownload.getState().equals("\u8f6c\u5b58\u5b8c\u6210")) {
            musicDownload.setState("\u8fc7\u671f");
        } else if (musicDownload.getState().equals("\u5220\u9664")) {
            musicDownload.setState("\u5220\u9664\u4e14\u8fc7\u671f");
        }
        this.musicDownloadMapper.updateById((Object)musicDownload);
        this.rfFile(musicDownload.getDownloadUrl());
        return 1;
    }

    private int rfFile(String name) {
        String sourceFolder = "/www/wwwroot/" + name;
        if (name.contains(".zip")) {
            Path filePath = Paths.get(sourceFolder, new String[0]);
            try {
                Files.delete(filePath);
                System.out.println("\u6587\u4ef6\u5df2\u6210\u529f\u5220\u9664\uff01");
            }
            catch (IOException e) {
                System.err.println("\u5220\u9664\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            }
        } else {
            File folder = new File(sourceFolder);
            boolean result = MusicDownloadService.deleteFolderRecursively((File)folder);
            if (result) {
                System.out.println("\u6587\u4ef6\u5939\u5df2\u6210\u529f\u5220\u9664\uff01");
            } else {
                System.out.println("\u65e0\u6cd5\u5220\u9664\u6587\u4ef6\u5939\uff01");
            }
        }
        return 1;
    }

    private int rf(String name) {
        String sourceFolder = "/www/wwwroot/m3/Qobuz Downloads/" + name;
        if (name.contains(".zip")) {
            Path filePath = Paths.get(sourceFolder, new String[0]);
            try {
                Files.delete(filePath);
                System.out.println("\u6587\u4ef6\u5df2\u6210\u529f\u5220\u9664\uff01");
            }
            catch (IOException e) {
                System.err.println("\u5220\u9664\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            }
        } else {
            File folder = new File(sourceFolder);
            boolean result = MusicDownloadService.deleteFolderRecursively((File)folder);
            if (result) {
                System.out.println("\u6587\u4ef6\u5939\u5df2\u6210\u529f\u5220\u9664\uff01");
            } else {
                System.out.println("\u65e0\u6cd5\u5220\u9664\u6587\u4ef6\u5939\uff01");
            }
        }
        return 1;
    }

    public static boolean deleteFolderRecursively(File folder) {
        if (folder.exists()) {
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!(file.isDirectory() ? !MusicDownloadService.deleteFolderRecursively((File)file) : !file.delete())) continue;
                    return false;
                }
            }
            return folder.delete();
        }
        return true;
    }

    @Async
    private void updateSchedule(MusicDownload musicDownload, int downloadedCount) {
        Float number = Float.valueOf(musicDownload.getNumber().intValue());
        Float schedule = Float.valueOf((float)downloadedCount / number.floatValue() * 100.0f);
        if (schedule.floatValue() > 100.0f) {
            schedule = Float.valueOf(100.0f);
        }
        if (schedule.floatValue() > 1.0f) {
            schedule = Float.valueOf(schedule.floatValue() - 1.0f);
        }
        musicDownload.setSchedule(Integer.valueOf(Math.round(schedule.floatValue())));
        this.musicDownloadMapper.updateById((Object)musicDownload);
    }

    private static String getName(String s) {
        String name = null;
        String[] ss = s.split("Qobuz Downloads/");
        if (ss.length > 1 && (ss = ss[1].split("/")).length > 0) {
            name = ss[0];
        }
        return name;
    }

    public int linkCheck(String url, Integer uid) {
        String[] ss = url.split("/");
        String qID = ss[ss.length - 1];
        try {
            MusicDownload mGet_fr = null;
            String type = null;
            if (url.contains("jp-ja")) {
                mGet_fr = this.jp_ja(qID, url, uid);
                type = mGet_fr.getType();
            } else if (url.contains("fr-fr")) {
                mGet_fr = this.fr_fr(qID, url, uid);
                type = mGet_fr.getType();
            } else {
                mGet_fr = this.fr_fr(qID, url, uid);
                type = mGet_fr.getType();
            }
            if (type == null) {
                MusicDownload musicDownload = new MusicDownload();
                musicDownload.setName(url);
                musicDownload.setNumber(Integer.valueOf(0));
                musicDownload.setUrl(url);
                musicDownload.setType("Qobuz");
                musicDownload.setState("\u94fe\u63a5\u5206\u6790\u5931\u8d25");
                musicDownload.setSchedule(Integer.valueOf(0));
                musicDownload.setId(Long.valueOf(System.currentTimeMillis()));
                musicDownload.setUserId(uid);
                this.musicDownloadMapper.insert((Object)musicDownload);
                return 0;
            }
            MusicDownload musicDownload = new MusicDownload();
            musicDownload.setName(mGet_fr.getName());
            musicDownload.setNumber(mGet_fr.getNumber());
            musicDownload.setPoints(Integer.valueOf((mGet_fr.getNumber() - 1) / 20 + 1));
            musicDownload.setUrl(mGet_fr.getUrl());
            musicDownload.setType(type);
            musicDownload.setState("\u94fe\u63a5\u5206\u6790\u6210\u529f");
            musicDownload.setSchedule(Integer.valueOf(0));
            musicDownload.setId(Long.valueOf(System.currentTimeMillis()));
            musicDownload.setUserId(uid);
            this.musicDownloadMapper.insert((Object)musicDownload);
            return 1;
        }
        catch (IOException e) {
            if (e.getMessage().contains("Status=404")) {
                System.out.println("\u63d0\u53d6\u5931\u8d25\uff0c\u94fe\u63a5\u9519\u8bef\u3002");
            }
            MusicDownload musicDownload = new MusicDownload();
            musicDownload.setName(url);
            musicDownload.setNumber(Integer.valueOf(0));
            musicDownload.setUrl(url);
            musicDownload.setType("Qobuz");
            musicDownload.setState("\u94fe\u63a5\u5206\u6790\u5931\u8d25");
            musicDownload.setSchedule(Integer.valueOf(0));
            musicDownload.setId(Long.valueOf(System.currentTimeMillis()));
            musicDownload.setUserId(uid);
            this.musicDownloadMapper.insert((Object)musicDownload);
            return 0;
        }
    }

    private MusicDownload fr_fr(String qID, String url, Integer uid) throws IOException {
        MusicDownload musicDownload = new MusicDownload();
        Document doc = Jsoup.connect((String)("https://www.qobuz.com/fr-fr/album/" + qID)).get();
        String title = doc.title();
        Element elementPlayerTracks = doc.getElementById("playerTracks");
        if (elementPlayerTracks == null) {
            return null;
        }
        Elements elementsPlayerItem = Objects.requireNonNull(doc.getElementById("about")).getElementsByClass("album-about__items");
        int num = 0;
        if (!elementsPlayerItem.isEmpty()) {
            Element e = ((Element)elementsPlayerItem.get(0)).child(0);
            String s = e.text();
            String sa = s.split("- ")[1].split(" piste")[0];
            num = Integer.parseInt(sa);
        }
        musicDownload.setName(title);
        musicDownload.setNumber(Integer.valueOf(num));
        musicDownload.setType("Qobuz-fr");
        musicDownload.setUrl("https://www.qobuz.com/fr-fr/album/" + qID);
        return musicDownload;
    }

    private MusicDownload jp_ja(String qID, String url, Integer uid) throws IOException {
        MusicDownload musicDownload = new MusicDownload();
        Document doc = Jsoup.connect((String)("https://www.qobuz.com/jp-ja/album/" + qID)).get();
        String title = doc.title();
        Element elementPlayerTracks = doc.getElementById("playerTracks");
        if (elementPlayerTracks == null) {
            this.musicDownloadMapper.insert((Object)musicDownload);
            return null;
        }
        Elements elementsPlayerItem = Objects.requireNonNull(doc.getElementById("about")).getElementsByClass("album-about__items");
        int num = 0;
        if (!elementsPlayerItem.isEmpty()) {
            Element e = ((Element)elementsPlayerItem.get(0)).child(0);
            String s = e.text();
            String sa = s.split("\u53ce\u9332\u6570 : ")[1].split("\u66f2")[0];
            num = Integer.parseInt(sa);
        }
        musicDownload.setName(title);
        musicDownload.setNumber(Integer.valueOf(num));
        musicDownload.setType("Qobuz-jp");
        musicDownload.setUrl("https://www.qobuz.com/jp-ja/album/" + qID);
        return musicDownload;
    }

    public Integer getUidByUserName(String userName) {
        return this.musicDownloadMapper.getUidByUserName(userName);
    }

    public IPage<MusicDownload> list(Integer uid, int pageSize, int pageNum) {
        Page page = new Page((long)pageNum, (long)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"user_id", (Object)uid)).notLike((Object)"state", (Object)"\u5220\u9664")).orderByDesc((Object)"id");
        return this.musicDownloadMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    public MusicDownload getOne(Long id) {
        return (MusicDownload)this.musicDownloadMapper.selectById((Serializable)id);
    }

    public int startTransfer(Long id) {
        MusicDownload musicDownload = new MusicDownload();
        musicDownload.setId(id);
        musicDownload.setState("\u4e2d\u8f6c\u961f\u5217\u4e2d");
        this.musicDownloadMapper.updateById((Object)musicDownload);
        return 1;
    }

    public void musicDownloadMinusN(String userName, Integer n) {
        this.musicDownloadMapper.musicDownloadMinusN(userName, n);
        Integer id = this.musicDownloadMapper.getUidByUserName(userName);
        String count = this.payLog(Integer.valueOf(-n.intValue()), Long.valueOf(id.intValue()));
        this.musicDownloadMapper.addLog(count, Long.valueOf(id.intValue()));
    }

    public void musicDownloadAddOne(Integer uid, Integer num) {
        this.musicDownloadMapper.musicDownloadAdd(uid, num);
    }

    public int delete(Long id) {
        MusicDownload musicDownload = new MusicDownload();
        musicDownload.setId(id);
        musicDownload.setState("\u5220\u9664");
        this.musicDownloadMapper.updateById((Object)musicDownload);
        return 1;
    }

    public Long getTransferringAndDepositingCountByServiceNumber(Integer serviceNumber) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"state", (Object)"\u8f6c\u5b58\u4e2d")).eq((Object)"service_id", (Object)serviceNumber);
        return this.musicDownloadMapper.selectCount((Wrapper)queryWrapper);
    }

    public List<MusicDownload> getInTransitQueue(String serviceType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"state", (Object)"\u4e2d\u8f6c\u961f\u5217\u4e2d");
        queryWrapper.like(!StringUtil.isBlank((String)serviceType), (Object)"type", (Object)("%" + serviceType + "%"));
        queryWrapper.orderByAsc((Object)"number");
        return this.musicDownloadMapper.selectList((Wrapper)queryWrapper);
    }

    public String getFileName(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)id);
        MusicDownload musicDownload = (MusicDownload)this.musicDownloadMapper.selectOne((Wrapper)queryWrapper);
        return musicDownload.getFileName();
    }

    private static void addFolderToZip(ZipOutputStream zos, File fileToAdd, String parentFolderName) throws IOException {
        for (File item : fileToAdd.listFiles()) {
            int bytesRead;
            if (item.isDirectory()) {
                MusicDownloadService.addFolderToZip((ZipOutputStream)zos, (File)item, (String)(parentFolderName == null ? item.getName() : parentFolderName + "/" + item.getName()));
                continue;
            }
            byte[] buffer = new byte[1024];
            FileInputStream fis = new FileInputStream(item);
            zos.putNextEntry(new ZipEntry((parentFolderName != null ? parentFolderName + "/" : "") + item.getName()));
            while ((bytesRead = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, bytesRead);
            }
            zos.closeEntry();
            fis.close();
        }
    }

    public Integer getUserRemainingTransferQuantity(String userName) {
        return this.musicDownloadMapper.getUserRemainingTransferQuantity(userName);
    }

    public Long getNumberOfQueues() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"state", (Object)"\u4e2d\u8f6c\u961f\u5217\u4e2d");
        return this.musicDownloadMapper.selectCount((Wrapper)queryWrapper);
    }

    public Integer getUserRemainingTransferQuantityByID(Long id) {
        return this.musicDownloadMapper.getUserRemainingTransferQuantityByID(id);
    }

    public List<MusicDownload> getDeleteData(Integer serviceId) {
        return this.musicDownloadMapper.getDeleteData(serviceId);
    }

    public List<Map<String, Object>> getUIdsIsVIP() {
        return this.musicDownloadMapper.getUIdsIsVIP();
    }

    public void addDLNum(Long id, Integer num) {
        Integer now = this.musicDownloadMapper.getUserRemainingTransferQuantityByID(id);
        this.musicDownloadMapper.addDLNum(id, num);
        int add = num - now;
        if (add != 0) {
            String count = this.addLog(Integer.valueOf(add));
            this.musicDownloadMapper.addLog(count, id);
        }
    }

    public String addLog(Integer num) {
        String log = "{\"reason\": \"adjust\", \"category\": 35, \"user_agent\": \"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36\", \"points_change\": 3}";
        JSONObject jsonObject = JSONObject.parseObject((String)log);
        jsonObject.put((Object)"points_change", (Object)num);
        return jsonObject.toString();
    }

    public String payLog(Integer num, Long uid) {
        String log = "{\"reason\": \"pay\", \"category\": 35, \"payment_id\": 2, \"user_agent\": \"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/19.0 Safari/605.1.15\", \"points_change\": -1}";
        JSONObject jsonObject = JSONObject.parseObject((String)log);
        jsonObject.put((Object)"points_change", (Object)num);
        jsonObject.put((Object)"payment_id", (Object)uid);
        return jsonObject.toString();
    }

    public List<Long> getUIdByOrder() {
        return this.musicDownloadMapper.getUIdByOrder();
    }

    public void upDateTimeOutTask() {
        this.musicDownloadMapper.upDateTimeOutTask();
    }

    public URL getM3Url4(String fileName) {
        URL url = null;
        try {
            url = new URL("https://pan4.yintu.top/dl/m3/" + fileName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public URL getM3Url5(String fileName) {
        URL url = null;
        try {
            url = new URL("https://pan5.yintu.top/dl/m3/" + fileName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getOssUrl(String fileName) {
        String endpoint = "https://intooo.com";
        EnvironmentVariableCredentialsProvider credentialsProvider = null;
        try {
            credentialsProvider = CredentialsProviderFactory.newEnvironmentVariableCredentialsProvider();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        String bucketName = "music-dl";
        String objectName = fileName;
        String region = "cn-hongkong";
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        clientBuilderConfiguration.setSignatureVersion(SignVersion.V4);
        OSS ossClient = OSSClientBuilder.create().endpoint(endpoint).credentialsProvider((CredentialsProvider)credentialsProvider).clientConfiguration((ClientConfiguration)clientBuilderConfiguration).region(region).build();
        try {
            URL url;
            Date expiration = new Date(new Date().getTime() + 3600000L);
            URL uRL = url = ossClient.generatePresignedUrl(bucketName, objectName, expiration);
            return uRL;
        }
        catch (OSSException oe) {
            System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            System.out.println("Error Message:" + oe.getErrorMessage());
            System.out.println("Error Code:" + oe.getErrorCode());
            System.out.println("Request ID:" + oe.getRequestId());
            System.out.println("Host ID:" + oe.getHostId());
        }
        catch (com.aliyun.oss.ClientException ce) {
            System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            System.out.println("Error Message:" + ce.getMessage());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return null;
    }

    public List<SearchDTO> search(String query, String platform, String region) {
        try {
            List list = QobuzSearchService.searchAlbums((String)query, (String)platform, (String)region);
            for (SearchDTO s : list) {
                s.setCoverUrl(s.getCoverUrl().replace("static.qobuz.com", "static-qobuz.intooo.com"));
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

