/*
 * Decompiled with CFR 0.152.
 */
package com.yh.dl.musicDownload.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yh.dl.ResponseResult;
import com.yh.dl.musicDownload.model.MusicDownload;
import com.yh.dl.musicDownload.model.MusicDownloadDTO;
import com.yh.dl.musicDownload.model.SearchDTO;
import com.yh.dl.musicDownload.service.MusicDownloadService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/musicDownload"})
@CrossOrigin(origins={"*"})
public class MusicDownloadController {
    @Autowired
    private MusicDownloadService dlService;

    @GetMapping(value={"/dl"})
    public ResponseResult DL(String qobuzURL) throws IOException {
        String line;
        String[] ss = qobuzURL.split("/");
        String qID = ss[ss.length - 1];
        String command = "qobuz-dl dl --no-db https://play.qobuz.com/album/" + qID;
        ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        return new ResponseResult();
    }

    @GetMapping(value={"/list"})
    public ResponseResult list(@RequestParam String userName, @RequestParam(defaultValue="10") int pageSize, @RequestParam(defaultValue="1") int pageNum) {
        ResponseResult responseResult = new ResponseResult();
        Integer id = this.dlService.getUidByUserName(userName);
        IPage page = this.dlService.list(id, pageSize, pageNum);
        ArrayList<MusicDownloadDTO> list = new ArrayList<MusicDownloadDTO>();
        for (MusicDownload m : page.getRecords()) {
            MusicDownloadDTO dto = new MusicDownloadDTO();
            BeanUtils.copyProperties((Object)m, (Object)dto);
            dto.setNumber(m.getNumber().toString());
            dto.setSchedule(m.getSchedule().toString());
            if (dto.getState().equals("\u8f6c\u5b58\u5b8c\u6210")) {
                if (m.getServiceId() == 2 || m.getServiceId() == 1) {
                    dto.setDownloadUrl(this.dlService.getOssUrl(dto.getFileName()).toString());
                } else if (m.getServiceId() == 4) {
                    dto.setDownloadUrl(this.dlService.getM3Url4(dto.getFileName()).toString());
                } else if (m.getServiceId() == 5) {
                    dto.setDownloadUrl(this.dlService.getM3Url5(dto.getFileName()).toString());
                }
            }
            list.add(dto);
        }
        responseResult.setData(list);
        responseResult.setCount(Long.valueOf(page.getTotal()));
        responseResult.setMessage("\u67e5\u8be2\u6210\u529f");
        responseResult.setState(Integer.valueOf(200));
        return responseResult;
    }

    @PostMapping(value={"/delete"})
    public ResponseResult delete(String id) {
        ResponseResult responseResult = new ResponseResult();
        this.dlService.delete(Long.valueOf(Long.parseLong(id)));
        responseResult.setMessage("\u5220\u9664\u6210\u529f");
        responseResult.setState(Integer.valueOf(200));
        return responseResult;
    }

    @PostMapping(value={"/startTransfer"})
    public ResponseResult startTransfer(String id, String userName) {
        ResponseResult responseResult = new ResponseResult();
        Integer i = this.dlService.getUserRemainingTransferQuantity(userName);
        MusicDownload musicDownload = this.dlService.getOne(Long.valueOf(Long.parseLong(id)));
        Integer n = musicDownload.getPoints();
        if (i != null && i >= n) {
            this.dlService.startTransfer(Long.valueOf(Long.parseLong(id)));
            this.dlService.musicDownloadMinusN(userName, n);
            responseResult.setMessage("\u6267\u884c\u6210\u529f\u6263\u9664\u79ef\u5206" + n);
            responseResult.setState(Integer.valueOf(200));
        } else {
            responseResult.setMessage("\u672c\u6b21\u6263\u9664\u79ef\u5206" + n + "\uff0c\u5269\u4f59\u79ef\u5206\u4e0d\u8db3");
            responseResult.setState(Integer.valueOf(201));
        }
        return responseResult;
    }

    @GetMapping(value={"/getUserRemainingTransferQuantity"})
    public ResponseResult getUserRemainingTransferQuantity(String userName) {
        ResponseResult responseResult = new ResponseResult();
        Integer i = this.dlService.getUserRemainingTransferQuantity(userName);
        responseResult.setData((Object)i);
        responseResult.setMessage("\u83b7\u53d6\u6210\u529f");
        responseResult.setState(Integer.valueOf(200));
        return responseResult;
    }

    @GetMapping(value={"/getNumberOfQueues"})
    public ResponseResult getNumberOfQueues() {
        ResponseResult responseResult = new ResponseResult();
        Long i = this.dlService.getNumberOfQueues();
        responseResult.setData((Object)i);
        responseResult.setMessage("\u83b7\u53d6\u6210\u529f");
        responseResult.setState(Integer.valueOf(200));
        return responseResult;
    }

    @PostMapping(value={"/extract"})
    public ResponseResult extract(String url, String userName) {
        ResponseResult responseResult = new ResponseResult();
        String message = "";
        if (url.contains(".qobuz.com/") && url.contains("/album/")) {
            Integer id = this.dlService.getUidByUserName(userName);
            int i = this.dlService.linkCheck(url, id);
            if (i == 1) {
                message = "\u6dfb\u52a0\u6210\u529f";
                responseResult.setState(Integer.valueOf(200));
            } else {
                message = "\u94fe\u63a5\u5206\u6790\u5931\u8d25\uff0c\u8bf7\u5728qobuz\u5e73\u53f0\u53f3\u4e0b\u89d2\u5207\u6362\u533a\u57df\u4e3a\u6cd5\u56fd\u6216\u65e5\u533a";
                responseResult.setState(Integer.valueOf(201));
            }
        } else {
            message = "\u94fe\u63a5\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\u94fe\u63a5\u662f\u5426\u6b63\u786e";
            responseResult.setState(Integer.valueOf(201));
        }
        responseResult.setMessage(message);
        return responseResult;
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<Resource> downloadFile(String id) throws MalformedURLException {
        String filename = this.dlService.getFileName(id);
        Path path = Paths.get("./Qobuz Downloads/", filename);
        UrlResource resource = new UrlResource(path.toUri());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)resource);
    }

    @GetMapping(value={"/search"})
    public ResponseResult<List<SearchDTO>> search(String query, String platform, String region) {
        ResponseResult responseResult = new ResponseResult();
        responseResult.setData((Object)this.dlService.search(query, platform, region));
        responseResult.setMessage("\u641c\u7d22\u6210\u529f");
        return responseResult;
    }
}

